/* @(#) somx/fsen.c 2.3 1/20/94 10:16:30 [5/15/94 17:59:02] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


/*===========================================================================*
 *                                                                           *
 * Name: fsen.c                                                              *
 *                                                                           *
 * Notes: This module implements the I/O Group Manager EnhancedAscii         *
 * which is an enhanced SOMPAscii I/O Group Manager which uses the           *
 * EnhancedMediaInterface class.                                             *
 *                                                                           *
 * History:                                                                  *
 * 4/2/93    : version 1                                                     *
 *                                                                           *
 *===========================================================================*/

#include <somp.h>

#define EnhancedAscii_Class_Source
#include <fsen.ih>
#include <enfmi.h>

#ifdef __IBMC__
  #pragma linkage(SOMInitModule, system)
  #pragma linkage(SOMInitemi, system)
#endif /* __IBMC__ */

SOMEXTERN void SOMLINK SOMInitModule (long majorVersion, long minorVersion)
{
  EnhancedAsciiNewClass(majorVersion, minorVersion);
  EnhancedMediaInterfaceNewClass(majorVersion, minorVersion);
}

SOMEXTERN void SOMLINK SOMInitemi ()
{
   SOMInitModule(0L, 0L);
}


SOM_Scope SOMPMediaInterfaceAbstract SOMLINK sompInstantiateMediaInterface(EnhancedAscii somSelf, Environment *ev)
{
    /* EnhancedAsciiData *somThis = EnhancedAsciiGetData(somSelf); */
    EnhancedAsciiMethodDebug("EnhancedAscii","sompInstantiateMediaInterface");

    return (EnhancedMediaInterfaceNew());
}

SOM_Scope void  SOMLINK somInit(EnhancedAscii somSelf)
{
    /* EnhancedAsciiData *somThis = EnhancedAsciiGetData(somSelf); */
    EnhancedAsciiMethodDebug("EnhancedAscii","somInit");

    EnhancedAscii_parent_SOMPAscii_somInit(somSelf);
    EnhancedMediaInterfaceNewClass(0,0);
}
